#pragma once
#include <mail/template_master/lib/types/template/database_template.h>
#include <mail/template_master/lib/types/task.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/types/optional.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/types/asio.h>

namespace NTemplateMaster::NDatabase {

class IDatabase : public yplatform::module {
public:
    virtual TExpected<TDatabaseTemplates> FindSimilarTemplates(
            NTemplateMaster::TContextPtr,
            const TTemplateFeaturesSet&,
            int32_t,
            int32_t,
            TYield) = 0;

    virtual TExpected<TOptional<TDatabaseTemplatePtr>> FindTemplateByStableSign(
            NTemplateMaster::TContextPtr,
            TTemplateStableSign,
            TYield) = 0;

    virtual TExpected<void> SaveTemplate(
            NTemplateMaster::TContextPtr,
            TDatabaseTemplatePtr,
            int32_t,
            TTemplatesStableSigns,
            TYield) = 0;

    virtual TExpected<size_t> DeleteTemplate(
            NTemplateMaster::TContextPtr,
            TTemplateStableSign,
            TYield) = 0;

    virtual TExpected<void> UpdateSearchFlag(
            NTemplateMaster::TContextPtr,
            bool,
            TTemplatesStableSigns,
            TYield) = 0;

    virtual TExpected<void> IndexTemplateFeatures(
            NTemplateMaster::TContextPtr,
            TTemplateFeaturesSet,
            TTemplateStableSign,
            TYield) = 0;

    virtual TExpected<void> IndexFeature(
            NTemplateMaster::TContextPtr,
            TTemplateFeature,
            TYield) = 0;

    virtual TExpected<TTemplateFeaturesSet> GetUnusedFeatures(
            NTemplateMaster::TContextPtr,
            TYield) = 0;

    virtual TExpected<void> RemoveTemplateFromFeaturesIndex(
            NTemplateMaster::TContextPtr,
            TTemplateStableSign,
            TYield) = 0;

    virtual TExpected<void> MoveTimeoutTask(
            NTemplateMaster::TContextPtr,
            TYield) = 0;

    virtual TExpected<TTasksInfos> GetReadyTasks(
            NTemplateMaster::TContextPtr,
            int32_t,
            TYield) = 0;

    virtual TExpected<void> FinishTask(
            NTemplateMaster::TContextPtr,
            std::string taskId,
            ETaskStatus taskStatus,
            TOptional<std::string> error,
            TYield) = 0;

    virtual void AsyncSaveTemplate(
            NTemplateMaster::TContextPtr,
            TDatabaseTemplatePtr,
            int32_t,
            TTemplatesStableSigns,
            std::function<void(TExpected<void>)>) = 0;

    virtual void AsyncMergeTemplates(
            NTemplateMaster::TContextPtr,
            TDatabaseTemplatePtr,
            int32_t,
            TTemplatesStableSigns,
            std::function<void(TExpected<bool>)>) = 0;

    virtual ~IDatabase() = default;
};

using TDatabasePtr = std::shared_ptr<IDatabase>;
}
