#pragma once
#include <mail/template_master/lib/db/queries/query_repository.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/types/template/stable_template.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/db/operations/operation_traits.h>

#include <ozo/result.h>
#include <ozo/request.h>
#include <ozo/execute.h>
#include <ozo/shortcuts.h>

#include <vector>

namespace NTemplateMaster::NDatabase::Operations {

template<typename TQueryRepository>
class TDeleteTemplateOp {
private:
    using TDeleteTemplate = NTemplateMaster::NDatabase::NQuery::TDeleteTemplate;
public:
    TDeleteTemplateOp(
            TQueryRepository queryRepository,
            TTemplateStableSign stableSign)
        : QueryRepository(std::move(queryRepository))
        , StableSign(stableSign)
    {}

    template<typename TProvider>
    TExpected<size_t> operator()(
            NTemplateMaster::TContextPtr context,
            TProvider&& provider,
            ozo::time_traits::duration requestTimeout,
            TYield yield)
    {
        using Adl::request;

        boost::system::error_code ec;
        TDeleteTemplate deleteTemplateParams;
        deleteTemplateParams.stable_sign = StableSign;
        const auto deleteQ = QueryRepository.template make_query<TDeleteTemplate>(deleteTemplateParams);

        std::vector<typename TDeleteTemplate::result_type> result;
        auto connection = request(std::forward<TProvider>(provider), deleteQ,
                requestTimeout, ozo::into(result), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, deleteQ, connection);
            return yamail::make_unexpected(ec);
        }
        return result.size();
    }
private:
    TQueryRepository QueryRepository;
    TTemplateStableSign StableSign;
};

}
