#pragma once
#include <mail/template_master/lib/db/queries/query_repository.h>
#include <mail/template_master/lib/db/operations/operation_traits.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/types/template/stable_template.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/types/expected.h>

#include <ozo/result.h>
#include <ozo/request.h>
#include <ozo/transaction.h>
#include <ozo/shortcuts.h>

#include <vector>

namespace NTemplateMaster::NDatabase::Operations {

template<typename TQueryRepository>
class TFindTemplateByStableSignOp {
private:
    using TFindTemplateByStableSign = NTemplateMaster::NDatabase::NQuery::TFindTemplateByStableSign;
public:
    TFindTemplateByStableSignOp(
            TQueryRepository queryRepository,
            TTemplateStableSign stableSign)
        : QueryRepository(std::move(queryRepository))
        , StableSign(stableSign)
    {}

    template<typename TProvider>
    TExpected<TOptional<TDatabaseTemplatePtr>> operator() (
            NTemplateMaster::TContextPtr context,
            TProvider&& provider,
            ozo::time_traits::duration requestTimeout,
            TYield yield)
    {
        using Adl::request;

        boost::system::error_code ec;
        std::vector<typename TFindTemplateByStableSign::result_type> rows;
        TFindTemplateByStableSign findTemplateParams;
        findTemplateParams.stable_sign = StableSign;
        const auto findQ = QueryRepository.template make_query<TFindTemplateByStableSign>(findTemplateParams);

        auto connection = request(std::forward<TProvider>(provider), findQ,
                requestTimeout, ozo::into(rows), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, findQ, connection);
            return yamail::make_unexpected(ec);
        }
        if (!rows.empty()) {
            const auto& [stableSign, sign, json] = rows[0];
            return MakeExpected(TOptional<TDatabaseTemplatePtr>(std::make_shared<TDatabaseTemplate>(
                stableSign, TTemplateFeaturesSet(sign.begin(), sign.end()), json.raw_string(), TJsonAttributesArray{})));
        }
        return TOptional<TDatabaseTemplatePtr>();
    }
private:
    TQueryRepository QueryRepository;
    TTemplateStableSign StableSign;
};

}
