#pragma once
#include <mail/template_master/lib/db/queries/query_repository.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/types/task.h>
#include <mail/template_master/lib/db/operations/operation_traits.h>
#include <mail/yreflection/include/yamail/data/deserialization/yajl.h>

#include <ozo/result.h>
#include <ozo/execute.h>
#include <ozo/request.h>
#include <ozo/shortcuts.h>
#include <ozo/pg/types/jsonb.h>

#include <vector>
#include <chrono>

namespace NTemplateMaster::NDatabase::Operations {

class TGetReadyTasksOp {
private:
    using TGetReadyTasks = NTemplateMaster::NDatabase::NQuery::TGetReadyTasks;
    using TTasksInfos = ::NTemplateMaster::TTasksInfos;
public:
    TGetReadyTasksOp(
            TQueryRepository queryRepository,
            int32_t limit)
        : QueryRepository(std::move(queryRepository))
        , Limit(limit)
    {}

    template<typename TProvider>
    TExpected<TTasksInfos> operator()(
            NTemplateMaster::TContextPtr context,
            TProvider&& provider,
            ozo::time_traits::duration requestTimeout,
            TYield yield) {
        static_assert(ozo::ConnectionProvider<TProvider>);

        boost::system::error_code ec;
        std::vector<typename TGetReadyTasks::result_type> rows;
        TGetReadyTasks getReadyTasksParams;
        getReadyTasksParams.limit = Limit;
        const auto getReadyTasksQ = QueryRepository.make_query<TGetReadyTasks>(getReadyTasksParams);

        auto conn = ozo::request(std::forward<TProvider>(provider), getReadyTasksQ, requestTimeout, ozo::into(rows), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, getReadyTasksQ, conn);
            return yamail::make_unexpected(ec);
        }
        return {Convert(rows)};
    }
private:
    template<typename TRows>
    TTasksInfos Convert(const TRows& rows) {
        TTasksInfos tasksInfos;
        for (auto&& row : rows) {
            const auto taskId = std::get<0>(row);
            const auto taskType = std::get<1>(row);
            const auto scheduleTime = std::get<2>(row);
            const auto createdTimestamp = std::get<3>(row);
            const auto timeout = std::get<4>(row);
            ::NTemplateMaster::ETaskStatus status;
            yamail::data::deserialization::from_string(std::get<5>(row), status);
            const auto context = std::get<6>(row).raw_string();
            tasksInfos.emplace_back(taskId, taskType, scheduleTime, createdTimestamp, timeout, status, context);
        }
        return tasksInfos;
    }

    TQueryRepository QueryRepository;
    const int32_t Limit;
};

}
