#pragma once
#include <mail/template_master/lib/db/queries/query_repository.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/types/template/template_sign.h>
#include <mail/template_master/lib/db/operations/operation_traits.h>

#include <ozo/shortcuts.h>

#include <vector>

namespace NTemplateMaster::NDatabase::Operations {

template<typename TQueryRepository>
class TGetUnusedFeaturesOp {
private:
    using TGetUnusedFeatures = NTemplateMaster::NDatabase::NQuery::TGetUnusedFeatures;
public:
    TGetUnusedFeaturesOp(TQueryRepository queryRepository)
        : QueryRepository(std::move(queryRepository))
    {}

    template<typename TProvider>
    TExpected<TTemplateFeaturesSet> operator()(
            NTemplateMaster::TContextPtr context,
            TProvider&& provider,
            ozo::time_traits::duration requestTimeout,
            TYield yield) {
        using Adl::request;
        using Adl::execute;
        using Adl::begin;
        using Adl::commit;

        boost::system::error_code ec;
        std::vector<typename TGetUnusedFeatures::result_type> result;
        TGetUnusedFeatures getUnusedFeaturesParams;
        const auto getUnusedFeaturesQ = QueryRepository.template make_query<TGetUnusedFeatures>(getUnusedFeaturesParams);

        auto transaction = begin(std::forward<TProvider>(provider), requestTimeout, yield[ec]);
        if (ec) {
            LogOzoError(context, ec, "begin", transaction);
            return yamail::make_unexpected(ec);
        }
        request(transaction, getUnusedFeaturesQ, requestTimeout, ozo::into(result), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, getUnusedFeaturesQ, transaction);
            return yamail::make_unexpected(ec);
        }
        commit(std::move(transaction), requestTimeout, yield[ec]);
        if (ec) {
            LogOzoError(context, ec, "commit", transaction);
            return yamail::make_unexpected(ec);
        }
        return TTemplateFeaturesSet{result.begin(), result.end()};
    }
private:
    const TQueryRepository QueryRepository;
};

}
