#pragma once
#include <mail/template_master/lib/db/queries/query_repository.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/db/operations/operation_traits.h>

#include <ozo/result.h>
#include <ozo/execute.h>
#include <ozo/shortcuts.h>
#include <ozo/pg/types/jsonb.h>

#include <vector>

namespace NTemplateMaster::NDatabase::Operations {

class TIndexFeatureOp {
private:
    using TUpdateFeatureStableSigns = NTemplateMaster::NDatabase::NQuery::TUpdateFeatureStableSigns;
public:
    TIndexFeatureOp(
            TQueryRepository queryRepository,
            ::NTemplateMaster::TTemplateFeature feature)
        : QueryRepository(std::move(queryRepository))
        , Feature(feature)
    {}

    template<typename TProvider>
    TExpected<void> operator()(
            NTemplateMaster::TContextPtr context,
            TProvider&& provider,
            ozo::time_traits::duration requestTimeout,
            TYield yield) {
        static_assert(ozo::ConnectionProvider<TProvider>);

        boost::system::error_code ec;
        TUpdateFeatureStableSigns updateFeatureStableSignsParams;
        updateFeatureStableSignsParams.feature = Feature;
        const auto updateFeatureStableSignsQ = QueryRepository.make_query<TUpdateFeatureStableSigns>(updateFeatureStableSignsParams);

        auto transaction = ozo::begin(std::forward<TProvider>(provider), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, "begin", transaction);
            return yamail::make_unexpected(ec);
        }
        ozo::execute(transaction, updateFeatureStableSignsQ, requestTimeout, yield[ec]);
        if (ec) {
            LogOzoError(context, ec, updateFeatureStableSignsQ, transaction);
            return yamail::make_unexpected(ec);
        }
        ozo::commit(std::move(transaction), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, "commit", transaction);
            return yamail::make_unexpected(ec);
        }
        return {};
    }
private:
    TQueryRepository QueryRepository;
    const ::NTemplateMaster::TTemplateFeature Feature;
};

}
