#pragma once
#include <mail/template_master/lib/db/queries/query_repository.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/db/operations/operation_traits.h>

#include <ozo/result.h>
#include <ozo/execute.h>
#include <ozo/shortcuts.h>
#include <ozo/pg/types/jsonb.h>

#include <vector>

namespace NTemplateMaster::NDatabase::Operations {

class TIndexTemplateFeaturesOp {
private:
    using TIndexTemplateFeatures = NTemplateMaster::NDatabase::NQuery::TIndexTemplateFeatures;
public:
    TIndexTemplateFeaturesOp(
            TQueryRepository queryRepository,
            ::NTemplateMaster::TTemplateStableSign stableSign,
            ::NTemplateMaster::TTemplateFeaturesSet features)
        : QueryRepository(std::move(queryRepository))
        , StableSign(stableSign)
        , Features(features)
    {}

    template<typename TProvider>
    TExpected<void> operator()(
            NTemplateMaster::TContextPtr context,
            TProvider&& provider,
            ozo::time_traits::duration requestTimeout,
            TYield yield) {
        static_assert(ozo::ConnectionProvider<TProvider>);

        boost::system::error_code ec;
        TIndexTemplateFeatures indexTemplateFeaturesParams;
        indexTemplateFeaturesParams.features = {Features.begin(), Features.end()};
        indexTemplateFeaturesParams.stable_sign = StableSign;
        const auto indexTemplateFeaturesQ = QueryRepository.make_query<TIndexTemplateFeatures>(indexTemplateFeaturesParams);

        auto transaction = ozo::begin(std::forward<TProvider>(provider), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, "begin", transaction);
            return yamail::make_unexpected(ec);
        }
        ozo::execute(transaction, indexTemplateFeaturesQ, requestTimeout, yield[ec]);
        if (ec) {
            LogOzoError(context, ec, indexTemplateFeaturesQ, transaction);
            return yamail::make_unexpected(ec);
        }
        ozo::commit(std::move(transaction), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, "commit", transaction);
            return yamail::make_unexpected(ec);
        }
        return {};
    }
private:
    TQueryRepository QueryRepository;
    const ::NTemplateMaster::TTemplateStableSign StableSign;
    const ::NTemplateMaster::TTemplateFeaturesSet Features;
};

}
