#pragma once
#include <mail/template_master/lib/db/queries/query_repository.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/types/task.h>
#include <mail/template_master/lib/db/operations/operation_traits.h>
#include <mail/yreflection/include/yamail/data/deserialization/yajl.h>
#include <mail/yreflection/include/yamail/data/serialization/yajl.h>
#include <mail/template_master/lib/utils/errors.h>

#include <ozo/result.h>
#include <ozo/execute.h>
#include <ozo/request.h>
#include <ozo/shortcuts.h>
#include <ozo/pg/types/jsonb.h>

#include <vector>
#include <chrono>

namespace NTemplateMaster::NDatabase::Operations {

class TMoveTimeoutTaskOp {
private:
    using TGetTimeoutTask = NTemplateMaster::NDatabase::NQuery::TGetTimeoutTask;
    using TInsertRecentTask = NTemplateMaster::NDatabase::NQuery::TInsertRecentTask;
    using TRemoveRunningTask = NTemplateMaster::NDatabase::NQuery::TRemoveRunningTask;
    using TTasksInfos = ::NTemplateMaster::TTasksInfos;
    using ETaskStatus = ::NTemplateMaster::ETaskStatus;
public:
    TMoveTimeoutTaskOp(
            TQueryRepository queryRepository)
        : QueryRepository(std::move(queryRepository))
    {}

    template<typename TProvider>
    TExpected<void> operator()(
            NTemplateMaster::TContextPtr context,
            TProvider&& provider,
            ozo::time_traits::duration requestTimeout,
            TYield yield) {
        static_assert(ozo::ConnectionProvider<TProvider>);

        boost::system::error_code ec;
        std::vector<typename TGetTimeoutTask::result_type> rows;
        TGetTimeoutTask getTimeoutTaskParams;
        const auto getTimeoutTaskQ = QueryRepository.make_query<TGetTimeoutTask>(getTimeoutTaskParams);

        auto transaction = ozo::begin(std::forward<TProvider>(provider), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, "begin", transaction);
            return yamail::make_unexpected(ec);
        }
        ozo::request(transaction, getTimeoutTaskQ, requestTimeout, ozo::into(rows), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, getTimeoutTaskQ, transaction);
            return yamail::make_unexpected(ec);
        }
        if (rows.empty()) {
            ozo::rollback(std::move(transaction), yield[ec]);
            return {};
        }
        const auto row = rows[0];
        TInsertRecentTask insertRecentTaskParams;
        insertRecentTaskParams.id = std::get<0>(row);
        insertRecentTaskParams.type = std::get<1>(row);
        insertRecentTaskParams.created = std::get<3>(row);
        insertRecentTaskParams.started = std::get<4>(row);
        insertRecentTaskParams.status = yamail::data::serialization::to_string(ETaskStatus::TIMEOUT);
        insertRecentTaskParams.error = {};
        insertRecentTaskParams.context = std::get<7>(row);
        const auto insertRecentTaskQ = QueryRepository.make_query<TInsertRecentTask>(insertRecentTaskParams);
        ozo::execute(transaction, insertRecentTaskQ, requestTimeout, yield[ec]);
        if (ec) {
            LogOzoError(context, ec, insertRecentTaskQ, transaction);
            return yamail::make_unexpected(ec);
        }

        TRemoveRunningTask removeRunningTaskParams;
        removeRunningTaskParams.id = std::get<0>(row);
        const auto removeRunningTaskQ = QueryRepository.make_query<TRemoveRunningTask>(removeRunningTaskParams);
        ozo::execute(transaction, removeRunningTaskQ, requestTimeout, yield[ec]);
        if (ec) {
            LogOzoError(context, ec, removeRunningTaskQ, transaction);
            return yamail::make_unexpected(ec);
        }
        ozo::commit(std::move(transaction), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, "commit", transaction);
            return yamail::make_unexpected(ec);
        }
        return {};
    }
private:
    TQueryRepository QueryRepository;
};

}
