#pragma once
#include <mail/template_master/lib/db/queries/query_repository.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/db/operations/operation_traits.h>

#include <ozo/result.h>
#include <ozo/execute.h>
#include <ozo/shortcuts.h>
#include <ozo/pg/types/jsonb.h>

#include <vector>

namespace NTemplateMaster::NDatabase::Operations {

class TRemoveTemplatesFromFeaturesIndexOp {
private:
    using TRemoveTemplateFromFeaturesIndex = NTemplateMaster::NDatabase::NQuery::TRemoveTemplateFromFeaturesIndex;
public:
    TRemoveTemplatesFromFeaturesIndexOp(
            TQueryRepository queryRepository,
            ::NTemplateMaster::TTemplateStableSign stableSign)
        : QueryRepository(std::move(queryRepository))
        , StableSign(stableSign)
    {}

    template<typename TProvider>
    TExpected<void> operator()(
            NTemplateMaster::TContextPtr context,
            TProvider&& provider,
            ozo::time_traits::duration requestTimeout,
            TYield yield) {
        static_assert(ozo::ConnectionProvider<TProvider>);

        boost::system::error_code ec;
        TRemoveTemplateFromFeaturesIndex removeTemplateFromFeaturesIndexParams;
        removeTemplateFromFeaturesIndexParams.stable_sign = StableSign;
        const auto removeTemplateFromFeaturesIndexQ = QueryRepository.make_query<TRemoveTemplateFromFeaturesIndex>(removeTemplateFromFeaturesIndexParams);

        auto transaction = ozo::begin(std::forward<TProvider>(provider), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, "begin", transaction);
            return yamail::make_unexpected(ec);
        }
        ozo::execute(transaction, removeTemplateFromFeaturesIndexQ, requestTimeout, yield[ec]);
        if (ec) {
            LogOzoError(context, ec, removeTemplateFromFeaturesIndexQ, transaction);
            return yamail::make_unexpected(ec);
        }
        ozo::commit(std::move(transaction), yield[ec]);
        if (ec) {
            LogOzoError(context, ec, "commit", transaction);
            return yamail::make_unexpected(ec);
        }
        return {};
    }
private:
    TQueryRepository QueryRepository;
    const ::NTemplateMaster::TTemplateStableSign StableSign;
    const ::NTemplateMaster::TTemplateFeaturesSet Features;
};

}
