#pragma once
#include <mail/template_master/lib/db/queries/query_repository.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/types/template/template_sign.h>
#include <mail/template_master/lib/db/operations/operation_traits.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/types/expected.h>

#include <vector>

namespace NTemplateMaster::NDatabase::Operations {

template<typename TQueryRepository>
class TUpdateSearchFlagOp {
private:
    using TUpdateSearchFlag = NTemplateMaster::NDatabase::NQuery::TUpdateSearchFlag;
public:
    TUpdateSearchFlagOp(
            TQueryRepository queryRepository,
            bool search,
            TTemplatesStableSigns stableSigns)
        : QueryRepository(std::move(queryRepository))
        , Search(search)
        , StableSigns(std::move(stableSigns))
    {}

    template<typename TProvider>
    TExpected<void> operator()(
            NTemplateMaster::TContextPtr context,
            TProvider&& provider,
            ozo::time_traits::duration requestTimeout,
            TYield yield)
    {
        using Adl::execute;
        using Adl::begin;
        using Adl::commit;

        boost::system::error_code ec;
        TUpdateSearchFlag updateSearchFlagParams;
        updateSearchFlagParams.search = Search;
        updateSearchFlagParams.stable_sign_array = StableSigns;
        const auto updateSearchFlagsQ = QueryRepository.template make_query<TUpdateSearchFlag>(updateSearchFlagParams);

        auto transaction = begin(std::forward<TProvider>(provider), requestTimeout, yield[ec]);
        if (ec) {
            LogOzoError(context, ec, "begin", transaction);
            return yamail::make_unexpected(ec);
        }
        execute(transaction, updateSearchFlagsQ, requestTimeout, yield[ec]);
        if (ec) {
            LogOzoError(context, ec, updateSearchFlagsQ, transaction);
            return yamail::make_unexpected(ec);
        }
        commit(std::move(transaction), requestTimeout, yield[ec]);
        if (ec) {
            LogOzoError(context, ec, "commit", transaction);
            return yamail::make_unexpected(ec);
        }
        return {};
    }
private:
    const TQueryRepository QueryRepository;
    const bool Search;
    const TTemplatesStableSigns StableSigns;
};

}
