#pragma once
#include <mail/template_master/lib/types/match/similarity.h>
#include <mail/template_master/lib/types/optional.h>
#include <mail/template_master/lib/types/template/stable_sign.h>
#include <mail/template_master/lib/types/template/attributes.h>
#include <mail/template_master/lib/types/template/template_sign.h>

#include <ozo/pg/types/jsonb.h>
#include <ozo/pg/types.h>

#include <boost/hana/define_struct.hpp>

#include <string>

namespace NTemplateMaster::NDatabase::NQuery {

using TTemplateBody = ozo::pg::jsonb;

using TTaskId = ozo::pg::text;
using TTasksIds = std::vector<TTaskId>;
using TTaskType = ozo::pg::text;
using TTaskScheduleTimestamp = ozo::pg::timestamp;
using TTaskCreatedTimestamp = ozo::pg::timestamp;
using TTaskStartedTimestamp = ozo::pg::timestamp;
using TTaskError = TOptional<ozo::pg::text>;
using TTaskTimeout = ozo::pg::interval;
using TTaskStatus = ozo::pg::text;
using TTaskContext = ozo::pg::jsonb;

using namespace boost::hana::literals;

struct TFindSimilarTemplates {
    friend constexpr auto get_raw_query_name(const TFindSimilarTemplates&) noexcept {
        return "FindSimilarTemplates"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TFindSimilarTemplates,
        (std::vector<int32_t>, sign),
        (std::int32_t, limit),
        (std::int32_t, features_limit)
    );

    using parameters_type = TFindSimilarTemplates;
    using result_type = std::tuple<TTemplateStableSign, TTemplateFeaturesVector, TTemplateBody, TSimilarity>;
};

struct TSetSimilarThreshold {
    friend constexpr auto get_raw_query_name(const TSetSimilarThreshold&) noexcept {
        return "SetSimilarThreshold"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(SetSimilarThreshold);

    using parameters_type = TSetSimilarThreshold;
    using result_type = void;
};

struct TSaveTemplate {
    friend constexpr auto get_raw_query_name(const TSaveTemplate&) noexcept {
        return "SaveTemplate"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TSaveTemplate,
        (int64_t, stable_sign),
        (TTemplateFeaturesVector, features),
        (std::int32_t, features_limit),
        (TTemplatesStableSigns, parent_templates_stable_signs),
        (::NTemplateMaster::TJsonAttributesArray, attributes),
        (TTemplateBody, body)
    );

    using parameters_type = TSaveTemplate;
    using result_type = TTemplateStableSign;
};

struct TFindTemplateByStableSign {
    friend constexpr auto get_raw_query_name(const TFindTemplateByStableSign&) noexcept {
        return "FindTemplateByStableSign"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TFindTemplateByStableSign,
        (TTemplateStableSign, stable_sign)
    );

    using parameters_type = TFindTemplateByStableSign;
    using result_type = std::tuple<TTemplateStableSign, TTemplateFeaturesVector, TTemplateBody>;
};

struct TDeleteTemplate {
    friend constexpr auto get_raw_query_name(const TDeleteTemplate&) noexcept {
        return "DeleteTemplate"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TDeleteTemplate,
        (int64_t, stable_sign)
    );

    using parameters_type = TDeleteTemplate;
    using result_type = TTemplateStableSign;
};

struct TSelectForUpdateSearchFlag {
    friend constexpr auto get_raw_query_name(const TSelectForUpdateSearchFlag&) noexcept {
        return "SelectForUpdateSearchFlag"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TSelectForUpdateSearchFlag,
        (bool, search),
        (TTemplatesStableSigns, stable_sign_array)
    );

    using parameters_type = TSelectForUpdateSearchFlag;
    using result_type = TTemplateStableSign;
};

struct TUpdateSearchFlag {
    friend constexpr auto get_raw_query_name(const TUpdateSearchFlag&) noexcept {
        return "UpdateSearchFlag"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TUpdateSearchFlag,
        (bool, search),
        (TTemplatesStableSigns, stable_sign_array)
    );

    using parameters_type = TUpdateSearchFlag;
    using result_type = void;
};

struct TIndexTemplateFeatures {
    friend constexpr auto get_raw_query_name(const TIndexTemplateFeatures&) noexcept {
        return "IndexTemplateFeatures"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TIndexTemplateFeatures,
        (TTemplateFeaturesVector, features),
        (TTemplateStableSign, stable_sign)
    );

    using parameters_type = TIndexTemplateFeatures;
    using result_type = void;
};

struct TRemoveTemplateFromFeaturesIndex {
    friend constexpr auto get_raw_query_name(const TRemoveTemplateFromFeaturesIndex&) noexcept {
        return "RemoveTemplateFromFeaturesIndex"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TRemoveTemplateFromFeaturesIndex,
        (int64_t, stable_sign)
    );

    using parameters_type = TRemoveTemplateFromFeaturesIndex;
    using result_type = void;
};

struct TGetReadyTasks {
    friend constexpr auto get_raw_query_name(const TGetReadyTasks&) noexcept {
        return "GetReadyTasks"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TGetReadyTasks,
        (std::int32_t, limit)
    );

    using parameters_type = TGetReadyTasks;
    using result_type = std::tuple<TTaskId, TTaskType, TTaskScheduleTimestamp, TTaskCreatedTimestamp, TTaskTimeout, TTaskStatus, TTaskContext>;
};

struct TRemoveRunningTask {
    friend constexpr auto get_raw_query_name(const TRemoveRunningTask&) noexcept {
        return "RemoveRunningTask"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TRemoveRunningTask,
        (TTaskId, id)
    );

    using parameters_type = TRemoveRunningTask;
    using result_type = std::tuple<TTaskId, TTaskType, TTaskScheduleTimestamp, TTaskCreatedTimestamp, TTaskStartedTimestamp, TTaskTimeout, TTaskStatus, TTaskContext>;
};

struct TInsertRecentTask {
    friend constexpr auto get_raw_query_name(const TInsertRecentTask&) noexcept {
        return "InsertRecentTask"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TInsertRecentTask,
        (TTaskId, id),
        (TTaskType, type),
        (TTaskCreatedTimestamp, created),
        (TTaskStartedTimestamp, started),
        (TTaskStatus, status),
        (TTaskError, error),
        (TTaskContext, context)
    );

    using parameters_type = TInsertRecentTask;
    using result_type = void;
};

struct TGetTimeoutTask {
    friend constexpr auto get_raw_query_name(const TGetTimeoutTask&) noexcept {
        return "GetTimeoutTask"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TGetTimeoutTask);

    using parameters_type = TGetTimeoutTask;
    using result_type = std::tuple<TTaskId, TTaskType, TTaskScheduleTimestamp, TTaskCreatedTimestamp, TTaskStartedTimestamp, TTaskTimeout, TTaskStatus, TTaskContext>;
};

struct TUpdateFeatureStableSigns {
    friend constexpr auto get_raw_query_name(const TUpdateFeatureStableSigns&) noexcept {
        return "UpdateFeatureStableSigns"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TUpdateFeatureStableSigns,
        (TTemplateFeature, feature)
    );

    using parameters_type = TUpdateFeatureStableSigns;
    using result_type = void;
};

struct TGetUnusedFeatures {
    friend constexpr auto get_raw_query_name(const TGetUnusedFeatures&) noexcept {
        return "GetUnusedFeatures"_s;
    }

    BOOST_HANA_DEFINE_STRUCT(TGetUnusedFeatures);

    using parameters_type = TGetUnusedFeatures;
    using result_type = TTemplateFeature;
};

}
