#pragma once
#include <mail/template_master/lib/db/config.h>
#include <mail/template_master/lib/db/sharpei/sharpei_client.h>

#include <mail/template_master/lib/types/context.h>

#include <mail/yplatform/include/yplatform/time_traits.h>
#include <mail/ymod_httpclient/include/ymod_httpclient/client.h>
#include <mail/sharpei_client/include/sharpei_client/errors.h>

#include <chrono>
#include <memory>

namespace NTemplateMaster::NDatabase {
using namespace std::chrono_literals;

class TShardResolver {
public:
    TShardResolver(TSharpeiConfig config) {
        using namespace ::sharpei::client;

        RequestInfo requestInfo;
        auto httpClient = yplatform::find<yhttp::simple_call, std::shared_ptr>("http_client");
        auto sharpeiHttpClient = std::make_shared<NSharpei::TSharpeiHttpClient>(httpClient, config.ConnectionTimeout);
        auto sharpeiClient = ::sharpei::client::createSharpeiClient(sharpeiHttpClient, config.SharpeiClientSettings, requestInfo);
        SharpeiClient = makeCached(sharpeiClient, config.CacheTtl);
    }

    auto GetAllShards(TContextPtr, TYield yield) const noexcept {
        TAsyncCompletion<void(boost::system::error_code, ::sharpei::client::MapShard)> init(yield);
        auto handler = init.completion_handler;
        SharpeiClient->asyncStat([handler=std::move(handler)](
                const sharpei::client::ErrorCode& ec, ::sharpei::client::MapShard map_shard) mutable {
            boost::system::error_code err(ec.value(), sharpei::client::getErrorCategory());
            NUtils::Dispatch(handler, err, map_shard);
        });
        return init.result.get();
    }
private:
    ::sharpei::client::SharpeiClientPtr SharpeiClient;
};

using TShardResolverPtr = std::shared_ptr<TShardResolver>;
}
