#pragma once
#include <butil/http/arguments.h>
#include <butil/http/headers.h>

#include <mail/sharpei_client/include/sharpei_client/sharpei_client.h>
#include <mail/sharpei_client/include/sharpei_client/http.h>

#include <ymod_httpclient/client.h>

namespace NTemplateMaster::NDatabase::NSharpei {
using ::sharpei::client::http::HttpClient;
using ::sharpei::client::http::Address;
using ::sharpei::client::http::Arguments;
using ::sharpei::client::http::Headers;
using ::sharpei::client::http::ResponseHandler;
using ::sharpei::client::http::Timeout;

class TSharpeiHttpClient final : public HttpClient {
public:
    TSharpeiHttpClient(
            std::shared_ptr<yhttp::simple_call> http_client,
            yplatform::time_traits::duration connection_timeout
    )
        : HttpClient(http_client)
        , ConnectionTimeout(connection_timeout)
    {}

    void aget(
            const Address& addr,
            Timeout timeout,
            const std::string& method,
            const Arguments& args,
            const Headers& headers,
            ResponseHandler handler,
            bool keepAlive,
            const std::string& requestId) const override
    {
        using ::sharpei::client::http::Response;
        using Request = yhttp::request;

        yhttp::options options;
        options.reuse_connection = keepAlive;
        options.timeouts.connect = ConnectionTimeout;
        options.timeouts.total = timeout;

        const auto host = "http://" + addr.host + ":" + std::to_string(addr.port) +
                method + "?" + HttpArguments{args}.format();
        HttpClient->async_run(
            boost::make_shared<yplatform::task_context>(requestId),
            Request::GET(host, http::headers {headers}.format()),
            options,
            [handler = std::move(handler)] (const auto& ec, auto response) {
                if (ec) {
                    return handler(ec, Response {0, ""});
                }
                handler(ec, Response {
                        static_cast<unsigned>(response.status),
                        std::move(response.body)
                });
            }
        );
    }

    void apost(const Address&, Timeout, const std::string&, const Arguments&,
            const Headers&, const std::string&, ResponseHandler, bool,
            const std::string&) const override {
        throw std::logic_error("SharpeiHttpClient::apost is not implemented");
    }

private:
    std::shared_ptr<yhttp::simple_call> HttpClient;
    yplatform::time_traits::duration ConnectionTimeout;
};

using TSharpeiHttpClientPtr = ::sharpei::client::http::HttpClientPtr;

}
