#pragma once
#include <mail/template_master/lib/http/create_template_handler.h>
#include <mail/template_master/lib/http/detemple_handler.h>
#include <mail/template_master/lib/http/delete_template_handler.h>
#include <mail/template_master/lib/http/find_template_handler.h>
#include <mail/template_master/lib/http/ping_handler.h>
#include <mail/template_master/lib/http/route_handler.h>
#include <mail/template_master/lib/http/unistat.h>

namespace NTemplateMaster::NHttp {

void BindHttpHandlers(::NTemplateMaster::TShingerPrintPtr shingerPrint) {
    auto server = yplatform::find<ymod_webserver::server>("web_server");
    auto ping = std::make_shared<NHttp::TPing>();
    server->bind("", ping->Paths(), [=](auto&& stream) {
        auto req = ping->Init(stream);
        ping->Execute(req);
    });

    auto detemple = std::make_shared<NHttp::TDetemple>(
            yplatform::find_reactor<std::shared_ptr>("template_master_reactor"), shingerPrint);
    server->bind("", detemple->Paths(), [=](auto&& stream) {
        auto req = detemple->Init(stream);
        detemple->Execute(req);
    });

    auto route = std::make_shared<NHttp::TRoute>(
            yplatform::find_reactor<std::shared_ptr>("router"), shingerPrint);
    server->bind("", route->Paths(), [=](auto&& stream) {
        auto req = route->Init(stream);
        route->Execute(req);
    });

    auto findTemplate = std::make_shared<NHttp::TFindTemplate>(
            yplatform::find_reactor<std::shared_ptr>("template_master_reactor"), shingerPrint);
    server->bind("", findTemplate->Paths(), [=](auto&& stream) {
        auto req = findTemplate->Init(stream);
        findTemplate->Execute(req);
    });

    auto deleteTemplate = std::make_shared<NHttp::TDeleteTemplate>(
            yplatform::find_reactor<std::shared_ptr>("template_master_reactor"));
    server->bind("", deleteTemplate->Paths(), [=](auto&& stream) {
        auto req = deleteTemplate->Init(stream);
        deleteTemplate->Execute(req);
    });

    auto createTemplate = std::make_shared<NHttp::TCreateTemplate>(
            yplatform::find_reactor<std::shared_ptr>("template_master_reactor"), shingerPrint);
    server->bind("", createTemplate->Paths(), [=](auto&& stream) {
        auto req = createTemplate->Init(stream);
        createTemplate->Execute(req);
    });

    auto unistat = std::make_shared<NHttp::TUnistat>();
    server->bind("", unistat->Paths(), [=](auto&& stream) {
        auto req = unistat->Init(stream);
        unistat->Execute(req);
    });
}

}
