#pragma once
#include <mail/template_master/lib/http/handler.h>
#include <mail/template_master/lib/http/utils.h>
#include <mail/template_master/lib/http/types.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/unistat/unistat.h>

#include <mail/template_master/lib/template_master/handlers/create_template_handler.h>

#include <mail/ymod_webserver/include/ymod_webserver/methods.h>
#include <mail/ymod_webserver/include/ymod_webserver/server.h>

#include <mail/yreflection/include/yamail/data/serialization/yajl.h>

namespace NTemplateMaster::NHttp {

class TCreateTemplate : public IHandler {
private:
    using TRequest = NTemplateMaster::THttpRouteRequest;
    using TCreateTemplateHandler = NTemplateMaster::NHandlers::TCreateTemplateHandler<TContentProcessor, TRequest>;
public:
    TCreateTemplate(TReactorPtr reactor, TContentProcessorPtr contentProcessor)
            : Reactor(std::move(reactor))
            , ContentProcessor(std::move(contentProcessor))
    {}

    THttpStreamPtr Init(THttpStreamPtr stream) const override {
        return THttpStreamPtr(stream.get(), CreateUnistatCallback(stream, Paths()));
    }

    THttpPaths Paths() const override {
        return {"/create_template"};
    }

    EHttpMethod Method() const override {
        return EHttpMethod::mth_post;
    }

    bool NeedTvm() const override {
        return false;
    }

    void Execute(THttpStreamPtr stream) override {
        auto context = boost::make_shared<TContext>(stream->request()->ctx(), GetRequestId(stream));
        auto body = boost::copy_range<std::string>(stream->request()->raw_body);
        std::vector<std::string> req;
        yamail::data::deserialization::fromJson(body, req);
        std::vector<TRequest> wrapped;
        for (std::string html : req) {
            wrapped.emplace_back();
            wrapped.back().Html = std::move(html);
        }

        auto db = yplatform::find<NTemplateMaster::NDatabase::IDatabase, std::shared_ptr>("database");

        int maxHashesCount = yplatform::find<ITemplateMaster, std::shared_ptr>("template_master")->GetMaxHashesCount();
        auto createTemplateHandler =
            std::make_shared<TCreateTemplateHandler>(context, wrapped, ContentProcessor, db, maxHashesCount);
        auto coro = [=](TYield yield) mutable {
            SetOperationResult((*createTemplateHandler)(yield), stream);
        };
        boost::asio::spawn(*Reactor->io(), std::move(coro), NTemplateMaster::NUtils::kCoroutineAttributes);

    }
private:
    TReactorPtr Reactor;
    TContentProcessorPtr ContentProcessor;
};
}
