#pragma once
#include <mail/template_master/lib/http/handler.h>
#include <mail/template_master/lib/http/utils.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/unistat/unistat.h>
#include <mail/template_master/lib/template_master/handlers/delete_template_handler.h>

#include <mail/ymod_webserver/include/ymod_webserver/methods.h>
#include <mail/ymod_webserver/include/ymod_webserver/server.h>
#include <mail/yreflection/include/yamail/data/serialization/yajl.h>

namespace NTemplateMaster::NHttp {

class TDeleteTemplate : public IHandler {
private:
    using TDeleteTemplateHandler = NTemplateMaster::NHandlers::TDeleteTemplateHandler;
public:
    TDeleteTemplate(TReactorPtr reactor)
        : Reactor(std::move(reactor))
    {}

    THttpStreamPtr Init(THttpStreamPtr stream) const override {
        return THttpStreamPtr(stream.get(), CreateUnistatCallback(stream, Paths()));
    }

    THttpPaths Paths() const override {
        return {"/delete_template"};
    }

    EHttpMethod Method() const override {
        return EHttpMethod::mth_get;
    }

    bool NeedTvm() const override {
        return false;
    }

    void Execute(THttpStreamPtr stream) override {
        auto context = boost::make_shared<TContext>(stream->request()->ctx(), GetRequestId(stream));
        const auto request = stream->request();
        const auto stableSignStr = request->url.param_value("stable_sign");
        if (stableSignStr.empty()) {
            const auto res = TDeleteResult(EDeleteStatus::Error);
            return stream->result(ymod_webserver::codes::bad_request, yamail::data::serialization::toJson(res));
        }
        const auto stableSign = boost::lexical_cast<int64_t>(stableSignStr);
        auto db = yplatform::find<NDatabase::IDatabase, std::shared_ptr>("database");
        auto deleteTemplateHandler = std::make_shared<TDeleteTemplateHandler>(context, stableSign, db);
        auto coro = NTemplateMaster::NUnistat::Wrap([=](TYield yield) mutable {
            SetOperationResult((*deleteTemplateHandler)(yield), stream);
        }, "api_/delete_template_time");
        boost::asio::spawn(*Reactor->io(), std::move(coro), NTemplateMaster::NUtils::kCoroutineAttributes);
    }
private:
    TReactorPtr Reactor;
};
}
