#pragma once
#include <mail/template_master/lib/http/handler.h>
#include <mail/template_master/lib/http/utils.h>
#include <mail/template_master/lib/http/types.h>
#include <mail/template_master/lib/utils/utils.h>
#include <mail/template_master/lib/unistat/unistat.h>

#include <mail/template_master/lib/template_master/handlers/find_template_handler.h>

#include <mail/ymod_webserver/include/ymod_webserver/methods.h>
#include <mail/ymod_webserver/include/ymod_webserver/server.h>

#include <mail/yreflection/include/yamail/data/serialization/yajl.h>

namespace NTemplateMaster::NHttp {

class TFindTemplate : public IHandler {
private:
    using TRequest = NTemplateMaster::THttpRouteRequest;
    using TFindTemplateHandler = NTemplateMaster::NHandlers::TFindTemplateHandler<TContentProcessor, TRequest>;
public:
    TFindTemplate(TReactorPtr reactor, TContentProcessorPtr contentProcessor)
        : Reactor(std::move(reactor))
        , ContentProcessor(std::move(contentProcessor))
    {}

    THttpStreamPtr Init(THttpStreamPtr stream) const override {
        return THttpStreamPtr(stream.get(), CreateUnistatCallback(stream, Paths()));
    }

    THttpPaths Paths() const override {
        return {"/find_template"};
    }

    EHttpMethod Method() const override {
        return EHttpMethod::mth_get;
    }

    bool NeedTvm() const override {
        return false;
    }

    void Execute(THttpStreamPtr stream) override {
        auto context = boost::make_shared<TContext>(stream->request()->ctx(), GetRequestId(stream));
        const auto request = stream->request();
        const auto stableSignStr = request->url.param_value("stable_sign");
        if (stableSignStr.empty()) {
            auto res = TFindTemplateResult<TStringToken>(NTemplateMaster::EFindTemplateStatus::Error);
            return stream->result(ymod_webserver::codes::bad_request, yamail::data::serialization::toJson(res));
        }
        const auto stableSign = boost::lexical_cast<int64_t>(stableSignStr);
        auto db = yplatform::find<NDatabase::IDatabase, std::shared_ptr>("database");
        auto findTemplateHandler = std::make_shared<TFindTemplateHandler>(context, stableSign, *ContentProcessor, db);
        auto coro = NTemplateMaster::NUnistat::Wrap([=](TYield yield) mutable {
            SetOperationResult((*findTemplateHandler)(yield), stream);
        }, "api_/find_template_time");
        boost::asio::spawn(*Reactor->io(), std::move(coro), NTemplateMaster::NUtils::kCoroutineAttributes);
    }
private:
    TReactorPtr Reactor;
    TContentProcessorPtr ContentProcessor;
};
}
