#pragma once
#include <mail/template_master/lib/types/http.h>

#include <mail/ymod_webserver/include/ymod_webserver/methods.h>
#include <mail/ymod_webserver/include/ymod_webserver/server.h>
#include <mail/yplatform/include/yplatform/find.h>
#include <mail/ymod_unistat/lib/unistat.h>
#include <mail/yreflection/include/yamail/data/serialization/yajl.h>

namespace NTemplateMaster::NHttp {

class IHandler {
public:
    virtual ~IHandler() = default;
    virtual THttpStreamPtr Init(THttpStreamPtr stream) const = 0;
    virtual THttpPaths Paths() const = 0;
    virtual EHttpMethod Method() const = 0;
    virtual bool NeedTvm() const = 0;
    virtual void Execute(THttpStreamPtr stream) = 0;

protected:
    template<typename OperationResult>
    void SetOperationResult(OperationResult&& result, THttpStreamPtr stream) {
        return stream->result(std::forward<OperationResult>(result),
                yamail::data::serialization::toJson(std::forward<OperationResult>(result)));
    }

    auto CreateUnistatCallback(THttpStreamPtr stream, THttpPaths paths) const {
        auto unistat = yplatform::find<NYmodUnistat::IUnistat>("unistat");
        return [stream, unistat = std::move(unistat), paths=std::move(paths)](auto*) {
            int code = stream->result_code();
            for (auto&& path : paths) {
                if (code >= 200 && code <= 299) {
                    unistat->Push("api_" + path + "_2xx_codes", 1);
                } else if (code >= 400 && code <= 499) {
                    unistat->Push("api_" + path + "_4xx_codes", 1);
                } else {
                    unistat->Push("api_" + path + "_5xx_codes", 1);
                }
            }
        };
    }
};

}
