#pragma once
#include <mail/template_master/lib/http/handler.h>

#include <ymod_webserver/methods.h>
#include <ymod_webserver/server.h>

namespace NTemplateMaster::NHttp {

class TPing : public IHandler {
public:
    THttpStreamPtr Init(THttpStreamPtr stream) const override {
        return THttpStreamPtr(stream.get(), CreateUnistatCallback(stream, Paths()));
    }

    THttpPaths Paths() const override {
        return {"/ping", "/tm_ping"};
    }

    EHttpMethod Method() const override {
        return EHttpMethod::mth_get;
    }

    bool NeedTvm() const override {
        return false;
    }

    void Execute(THttpStreamPtr stream) override {
        stream->result(ymod_webserver::codes::ok, "pong");
    }
};
}
