#pragma once
#include <mail/template_master/lib/http/handler.h>

#include <ymod_webserver/methods.h>
#include <ymod_webserver/server.h>

namespace NTemplateMaster::NHttp {

class TUnistat : public IHandler {
public:
    THttpStreamPtr Init(THttpStreamPtr stream) const override {
        return stream;
    }

    THttpPaths Paths() const override {
        return {"/unistat"};
    }

    EHttpMethod Method() const override {
        return EHttpMethod::mth_get;
    }

    bool NeedTvm() const override {
        return false;
    }

    void Execute(THttpStreamPtr stream) override {
        auto unistat = yplatform::find<NYmodUnistat::IUnistat>("unistat");
        stream->set_code(ymod_webserver::codes::ok);
        stream->set_content_type("application", "json");
        stream->result_body(unistat->GetValuesInJson(false));
    }
};
}
