#pragma once
#include <mail/template_master/lib/types/http.h>

#include <string>

namespace NTemplateMaster::NHttp {

static const std::string xRequestIdKey("x-request-id");

inline auto GetRequestId(THttpStreamPtr stream) {
    const auto headers = stream->request()->headers;
    const auto it = headers.find(xRequestIdKey);
    if (it == headers.end()) {
        return stream->request()->ctx()->uniq_id();
    }
    return it->second;
}

}
