#pragma once
#include <mail/yreflection/include/yamail/data/reflection.h>

#include <string>

namespace NTemplateMaster::NRouter {

struct TConfig {
    size_t Port;
    std::string Reactor;
    yplatform::time_traits::duration BanDuration;
    yplatform::time_traits::duration ConnectTimeout;
    yplatform::time_traits::duration TotalTimeout;
    bool ReuseConnection;
    size_t Retries;
    std::string Schema;
    std::string NannyDumpPath;
};
}

YREFLECTION_ADAPT_ADT(NTemplateMaster::NRouter::TConfig,
    YREFLECTION_WO_MEMBER_RENAMED(std::size_t, port, Port)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, reactor, Reactor)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, ban_duration_ms, yplatform::time_traits::milliseconds, BanDuration)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, connect_timeout_ms, yplatform::time_traits::milliseconds, ConnectTimeout)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, total_timeout_ms, yplatform::time_traits::milliseconds, TotalTimeout)
    YREFLECTION_WO_MEMBER_RENAMED(bool, reuse_connection, ReuseConnection)
    YREFLECTION_WO_MEMBER_RENAMED(size_t, retries, Retries)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, schema, Schema)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, nanny_dump_path, NannyDumpPath)
)
