#pragma once

#include <boost/property_tree/json_parser.hpp>

#include <mail/yplatform/include/yplatform/util/split.h>

#include <string>
#include <fstream>

namespace NTemplateMaster::NRouter {

class TNannyMeta {
public:
    TNannyMeta() = default;

    void Init(const std::string &dumpJsonPath) {
        std::ifstream file(dumpJsonPath);
        if (!file.is_open()) {
            throw std::runtime_error("Can't open nanny config dump \"" + dumpJsonPath + "\"");
        }

        std::noskipws(file);
        boost::property_tree::ptree tree;
        boost::property_tree::read_json(file, tree);
        try {
            std::string tags(tree.get<std::string>("properties.tags"));
            for (const std::string &tag : yplatform::util::split(tags, " ")) {
                if (tag.starts_with("a_dc_")) {
                    DataCenter = tag.substr(5);
                    break;
                }
            }
        } catch (const boost::property_tree::ptree_bad_path& e) {
            throw std::runtime_error("Error when read nanny config dump \"" + dumpJsonPath + "\"");
        }
    }

    TOptional<std::string> GetDC() const noexcept {
        if (DataCenter.empty()) {
            return TOptional<std::string>();
        } else {
            return DataCenter;
        }
    }

private:
    std::string DataCenter;
};
}
