#pragma once
#include <mail/template_master/lib/types/optional.h>
#include <mail/template_master/lib/router/node.h>

#include <util/system/guard.h>
#include <util/system/spinlock.h>
#include <util/random/random.h>

#include <memory>
#include <utility>
#include <vector>
#include <numeric>

namespace NTemplateMaster::NRouter {

class TNodeManager {
public:
    using TNodes = std::vector<TNodePtr>;

    explicit TNodeManager(TNodes nodes)
        : Nodes(std::move(nodes))
    {}

    auto GetAvailableNodes() const noexcept {
        TNodeManager::TNodes result;
        for (auto&& node : Nodes) {
            if (!node->IsBanned()) {
                result.emplace_back(node);
            }
        }
        return result;
    }

private:
    TNodes Nodes;
};

using TNodeManagerPtr = std::shared_ptr<TNodeManager>;
}
