#pragma once
#include <mail/yreflection/include/yamail/data/reflection/reflection.h>
#include <mail/yreflection/include/yamail/data/deserialization/yajl.h>

#include <string>
#include <fstream>

namespace NTemplateMaster::NRouter {

struct TQloudConfig {
    std::string DataCenter;
};

class TQloudMeta {
public:
    TQloudMeta() = default;

    void Init(std::string qloudMetaPath) {
        std::ifstream file(qloudMetaPath);
        if (!file.is_open()) {
            throw std::runtime_error("Can't open query conf file \"" + qloudMetaPath + "\"");
        }

        std::noskipws(file);
        const std::string text{std::istreambuf_iterator<char>(file), std::istreambuf_iterator<char>()};
        if (file.bad() || file.fail()) {
            throw std::runtime_error("Error when read query conf file \"" + qloudMetaPath + "\"");
        }
        yamail::data::deserialization::fromJson(text, Config);
    }

    std::string GetDC() const noexcept {
        return Config.DataCenter;
    }

private:
    TQloudConfig Config;
};
}

YREFLECTION_ADAPT_ADT(NTemplateMaster::NRouter::TQloudConfig,
    YREFLECTION_WO_MEMBER_RENAMED(std::string, datacenter, DataCenter)
)
