#pragma once
#include <mail/template_master/lib/router/node_manager.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/types/optional.h>
#include <mail/template_master/lib/types/expected.h>
#include <mail/template_master/lib/types/http.h>
#include <mail/template_master/lib/types/asio.h>

#include <atomic>
#include <string>

namespace NTemplateMaster::NRouter {

class IRouter: public yplatform::module {
public:
    IRouter()
        : NodeManager(std::make_shared<TNodeManager>(TNodeManager::TNodes()))
    {}

    virtual TExpected<THttpResponse> SendRequest(
            TContextPtr context,
            std::string body,
            TTemplateFeaturesSet features,
            TYield yield) = 0;

    virtual TOptional<std::string> GetDC() const = 0;

    virtual ~IRouter() = default;

    TNodeManagerPtr GetNodeManager() const noexcept {
        return std::atomic_load_explicit(&NodeManager, std::memory_order_acquire);
    }
protected:
    void UpdateNodeManager(TNodeManagerPtr newNodeManager) noexcept {
        std::atomic_exchange_explicit(&NodeManager, newNodeManager, std::memory_order_release);
    }
private:
    TNodeManagerPtr NodeManager;
};

using TRouterPtr = std::shared_ptr<IRouter>;

}
