#pragma once
#include <mail/yreflection/include/yamail/data/reflection.h>

namespace NTemplateMaster {

struct TConfig {
    size_t TemplatesLimitFindInDb;
    double JacquardMinValueForMerge;
    double CommonPartPercentMinValueForMerge;
    size_t MaxEqualTokensInMessage;
    yplatform::time_traits::milliseconds FeaturesUpdateInterval;
};
}

YREFLECTION_ADAPT_ADT(NTemplateMaster::TConfig,
    YREFLECTION_WO_MEMBER_RENAMED(std::size_t, templates_limit_find_in_db, TemplatesLimitFindInDb)
    YREFLECTION_WO_MEMBER_RENAMED(double, jacquard_min_value_for_merge, JacquardMinValueForMerge)
    YREFLECTION_WO_MEMBER_RENAMED(double, common_part_percent_min_value_for_merge, CommonPartPercentMinValueForMerge)
    YREFLECTION_WO_MEMBER_RENAMED(size_t, max_equal_tokens_in_message, MaxEqualTokensInMessage)
    YREFLECTION_WO_MEMBER_RENAMED_WITH_CAST(std::uint64_t, features_update_interval_ms,
                yplatform::time_traits::milliseconds, FeaturesUpdateInterval)
)
