#pragma once
#include <mail/template_master/lib/types/operation_result/detemple_result.h>
#include <mail/template_master/lib/types/operation_result/find_result.h>
#include <mail/template_master/lib/types/operation_result/create_result.h>
#include <mail/template_master/lib/types/template/attributes.h>
#include <mail/template_master/lib/types/operation_result/delete_result.h>
#include <mail/template_master/lib/types/optional.h>

#include <mail/yreflection/include/yamail/data/reflection.h>

#include <string>

using TStringToken = typename NTemplateMaster::TToken<std::string>;
using TStringTokenSequence = std::vector<TStringToken>;

template<>
inline const std::string& NTemplateMaster::GetTokenValue(const TStringToken& token) {
    static const std::string sentinelValue = "$$$$$";
    return token.Value.has_value() ? token.Value.value() : sentinelValue;
}

namespace NTemplateMaster {

class TEmailAttributes {
public:
    TEmailAttributes() = default;

    TEmailAttributes(std::string from, std::string subject, std::string queueId, TUids uids)
        : From(std::move(from))
        , Subject(std::move(subject))
        , QueueId(std::move(queueId))
        , Uids(std::move(uids))
    {}


    static const TEmailAttributes GetAttributesEternal() {
        static const TEmailAttributes eternal("", "", "MANUALLY CREATED", {});
        return eternal;
    }

    bool IsEternal() const {
        return this->QueueId == GetAttributesEternal().QueueId;
    }

    std::string From;
    std::string Subject;
    std::string QueueId;
    TUids Uids;
};

}

YREFLECTION_ADAPT_ADT(NTemplateMaster::TEmailAttributes,
    YREFLECTION_MEMBER_RENAMED(std::string, from, From)
    YREFLECTION_MEMBER_RENAMED(std::string, subject, Subject)
    YREFLECTION_MEMBER_RENAMED(std::string, queue_id, QueueId)
    YREFLECTION_MEMBER_RENAMED(NTemplateMaster::TUids, uids, Uids)
)

inline bool operator==(const NTemplateMaster::TEmailAttributes& lhs, const NTemplateMaster::TEmailAttributes& rhs) {
    return lhs.From == rhs.From && lhs.Subject == rhs.Subject &&
        lhs.QueueId == rhs.QueueId && lhs.Uids == rhs.Uids;
}

using TEmailDetempleResult = NTemplateMaster::TDetempleResult<TStringToken, NTemplateMaster::TEmailAttributes>;

YREFLECTION_ADAPT_ADT(TEmailDetempleResult,
    YREFLECTION_MEMBER_RENAMED(NTemplateMaster::EDetempleStatus, status, Status)
    YREFLECTION_MEMBER_RENAMED(TOptional<NTemplateMaster::TDelta<TStringToken>>, delta, Delta)
    YREFLECTION_MEMBER_RENAMED(TOptional<NTemplateMaster::TAttributesArray<NTemplateMaster::TEmailAttributes>>, attributes, Attributes)
    YREFLECTION_MEMBER_RENAMED(TOptional<NTemplateMaster::TTemplateStableSign>, stable_sign, StableSign)
)

YREFLECTION_ADAPT_ADT(NTemplateMaster::TFindTemplateResult<TStringToken>,
    YREFLECTION_MEMBER_RENAMED(NTemplateMaster::EFindTemplateStatus, status, Status)
    YREFLECTION_MEMBER_RENAMED(TOptional<NTemplateMaster::TTemplateChunks<TStringToken>>, chunks, Chunks)
    YREFLECTION_MEMBER_RENAMED(TOptional<NTemplateMaster::TTemplateStableSign>, stable_sign, StableSign)
)

YREFLECTION_ADAPT_ADT(NTemplateMaster::TDeleteResult,
    YREFLECTION_MEMBER_RENAMED(NTemplateMaster::EDeleteStatus, status, Status)
    YREFLECTION_MEMBER_RENAMED(TOptional<size_t>, deleted_templates, DeletedTemplatesCount)
)

YREFLECTION_ADAPT_ADT(NTemplateMaster::TCreateTemplateResult,
    YREFLECTION_MEMBER_RENAMED(NTemplateMaster::ECreateTemplateStatus, status, Status)
    YREFLECTION_MEMBER_RENAMED(TOptional<NTemplateMaster::TTemplateStableSign>, stable_sign, StableSign)
)
