#pragma once
#include <mail/template_master/lib/types/template/template_sign.h>
#include <mail/template_master/lib/types/token/token_traits.h>

#include <type_traits>

namespace NTemplateMaster {

template<typename TContentProcessor, typename TContent>
using ContentProcessorTokenSequenceType = std::decay_t<decltype(std::declval<TContentProcessor>().Tokenize(std::declval<const TContent&>()))>;

template<typename TContentProcessor, typename TContent>
using ContentProcessorTokenType = std::decay_t<decltype(*(std::declval<const ContentProcessorTokenSequenceType<TContentProcessor, TContent>&>().begin()))>;

template<typename TContentProcessor, typename TContent>
using ContentProcessorAttributesType = std::decay_t<decltype(std::declval<TContentProcessor>().ExtractAttributes(std::declval<const TContent&>()))>;

template<typename TContentProcessor, typename TContent>
using ContentProcessorDigestType = std::decay_t<decltype(std::declval<TContentProcessor>().CalculateDigest(std::declval<const ContentProcessorTokenSequenceType<TContentProcessor, TContent>&>()))>;

template<typename TContentProcessor, typename TContent, class = std::void_t<>>
struct IsContentProcessor : std::false_type {};

template<typename TContentProcessor, typename TContent>
struct IsContentProcessor<TContentProcessor, TContent, std::void_t<
        ContentProcessorAttributesType<TContentProcessor, TContent>,
        std::enable_if_t<std::is_same_v<ContentProcessorDigestType<TContentProcessor, TContent>, TTemplateFeaturesSet>, void>
        >
> : std::true_type {};

template<typename TContentProcessor, typename TContentType>
constexpr auto ContentProcessorConcept = IsContentProcessor<std::decay_t<TContentProcessor>, std::decay_t<TContentType>>::value;

template<typename TContentProcessor>
using TContentProcessorPtr = std::shared_ptr<TContentProcessor>;
}
