#pragma once
#include <mail/template_master/lib/db/database_module.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/types/operation_result/find_result.h>
#include <mail/template_master/lib/types/template/stable_template.h>
#include <mail/template_master/lib/template_master/handlers/log_utils.h>

#include <mail/yplatform/include/yplatform/find.h>
#include <mail/template_master/lib/types/operation_result/create_result.h>

namespace NTemplateMaster::NHandlers {

template<typename TContentProcessor, typename TContent>
class TCreateTemplateHandler {
public:
    static_assert(ContentProcessorConcept<TContentProcessor, TContent>, "must satisfy ContentProcessor concept");
    using TTokenType = ContentProcessorTokenType<TContentProcessor, TContent>;
    using TMessage = TMessage<TContentProcessor, TContent>;

    TCreateTemplateHandler(
            TContextPtr context,
            std::vector<TContent> msgs,
            std::shared_ptr<TContentProcessor> contentProcessor,
            NTemplateMaster::NDatabase::TDatabasePtr db,
            int maxHashesCount)
            : Context(std::move(context))
            , Msgs(std::move(msgs))
            , ContentProcessor(std::move(contentProcessor))
            , Db(std::move(db))
            , MaxHashesCount(maxHashesCount)
    {}

    TCreateTemplateResult operator()(TYield yield) {
        std::vector<std::shared_ptr<TMessage>> msgs;
        for (auto html : Msgs) {
            msgs.push_back(std::make_shared<TMessage>(*ContentProcessor, std::move(html)));
        }
        auto templ = msgs[0]->CreateUnstableTemplate();

        for (size_t i = 1; i < msgs.size(); ++i) {
            auto newTokens = NUtils::Diff(msgs[i], templ).GetCommonPart();
            templ->UpdateTokens(std::forward<TTokenSequence<TTokenType>>(newTokens));
        }
        templ->PushAttributes(TEmailAttributes::GetAttributesEternal());
        Db->SaveTemplate(Context, templ->CreateDatabaseTemplate(), MaxHashesCount, {}, yield);
        return {ECreateTemplateStatus::Success, templ->GetStableSign()};
    }
private:
    NTemplateMaster::TContextPtr Context;
    std::vector<TContent> Msgs;
    std::shared_ptr<TContentProcessor> ContentProcessor;
    NTemplateMaster::NDatabase::TDatabasePtr Db;
    int MaxHashesCount;
};

}
