#pragma once
#include <mail/template_master/lib/db/database_module.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/types/operation_result/delete_result.h>

namespace NTemplateMaster::NHandlers {

class TDeleteTemplateHandler {
public:
    TDeleteTemplateHandler(
            TContextPtr context,
            NTemplateMaster::TTemplateStableSign stableSign,
            NTemplateMaster::NDatabase::TDatabasePtr db)
        : Context(context)
        , StableSign(stableSign)
        , Db(std::move(db))
    {}

    auto operator()(TYield yield) -> TDeleteResult {
        const auto result = Db->DeleteTemplate(Context, StableSign, std::move(yield));
        if (result) {
            return {EDeleteStatus::Success, result.value()};
        }
        return {EDeleteStatus::Error};
    }
private:
    TContextPtr Context;
    const NTemplateMaster::TTemplateStableSign StableSign;
    NTemplateMaster::NDatabase::TDatabasePtr Db;
};
}
