#pragma once
#include <mail/template_master/lib/db/database_module.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/types/template/stable_template.h>
#include <mail/template_master/lib/router/router_module.h>
#include <mail/template_master/lib/template_master/template_master.h>
#include <mail/template_master/lib/template_pool/template_pool.h>
#include <mail/template_master/lib/unistat/unistat.h>
#include <mail/template_master/lib/template_master/handlers/log_utils.h>

#include <mail/yplatform/include/yplatform/find.h>
#include <mail/yreflection/include/yamail/data/deserialization/yajl.h>

namespace NTemplateMaster::NHandlers {

template<
        typename TContentProcessor,
        typename TContent,
        typename TDetempleObjectPtr>
class TDetempleHandler {
public:
    static_assert(ContentProcessorConcept<TContentProcessor, TContent>, "must satisfy ContentProcessor concept");
    using TAttributes = ContentProcessorAttributesType<TContentProcessor, TContent>;
    using TTokenType = ContentProcessorTokenType<TContentProcessor, TContent>;
    using TTemplateMasterPtr = NTemplateMaster::TTemplateMasterPtr<TContentProcessor, TContent, TDetempleObjectPtr>;

    TDetempleHandler(
            NTemplateMaster::TContextPtr context,
            TDetempleObjectPtr message,
            TTemplateMasterPtr templateMaster,
            std::optional<TDbHints> dbHints)
        : Context(std::move(context))
        , Message(std::move(message))
        , TemplateMaster(std::move(templateMaster))
        , DbHints(std::move(dbHints))
    {}

    auto operator()(TYield yield) -> TDetempleResult<TTokenType, TAttributes> {
        LogMessageDigest(Context, Message);
        if (Message->Size() == 0) {
            return {};
        }
        auto templatePool = TemplateMaster->FindTemplatePool();
        const auto res = NTemplateMaster::NUnistat::Wrap([=]() {
            return templatePool->AddToPool(Context, Message, DbHints, yield);
        }, "application_pool_AddToPool")();
        LogDetempleResult(Context, res);
        return res;
    }
private:
    TContextPtr Context;
    const TDetempleObjectPtr Message;
    TTemplateMasterPtr TemplateMaster;
    std::optional<TDbHints> DbHints;
};
}
