#pragma once
#include <mail/template_master/lib/db/database_module.h>
#include <mail/template_master/lib/types/context.h>
#include <mail/template_master/lib/types/operation_result/find_result.h>
#include <mail/template_master/lib/types/template/stable_template.h>

#include <mail/yplatform/include/yplatform/find.h>

namespace NTemplateMaster::NHandlers {

template<typename TContentProcessor, typename TContent>
class TFindTemplateHandler {
public:
    static_assert(ContentProcessorConcept<TContentProcessor, TContent>, "must satisfy ContentProcessor concept");
    using TTokenType = ContentProcessorTokenType<TContentProcessor, TContent>;

    TFindTemplateHandler(
            TContextPtr context,
            NTemplateMaster::TTemplateStableSign stableSign,
            TContentProcessor contentProcessor,
            NTemplateMaster::NDatabase::TDatabasePtr db)
        : Context(std::move(context))
        , StableSign(stableSign)
        , ContentProcessor(std::move(contentProcessor))
        , Db(std::move(db))
      {}

    auto operator()(TYield yield) -> TFindTemplateResult<TTokenType> {
        const auto result = Db->FindTemplateByStableSign(Context, StableSign, yield);
        if (result) {
            const auto opt_db_template = result.value();
            if (opt_db_template.has_value()) {
                const auto stableTemplate = opt_db_template.value()->template CreateStableTemplate
                        <TContentProcessor, TContent>(ContentProcessor);
                return {EFindTemplateStatus::Found, StableSign, stableTemplate->GetTokens()};
            }
            return {EFindTemplateStatus::NotFound};
        }
        return {EFindTemplateStatus::Error};
    }
private:
    NTemplateMaster::TContextPtr Context;
    const NTemplateMaster::TTemplateStableSign StableSign;
    const TContentProcessor ContentProcessor;
    NTemplateMaster::NDatabase::TDatabasePtr Db;
};
}
