#pragma once
#include <mail/template_master/lib/types/operation_request/email_http_request.h>
#include <mail/template_master/lib/types/template/stable_template.h>
#include <mail/template_master/lib/types/template/unstable_template.h>
#include <mail/template_master/lib/types/template/message.h>
#include <mail/template_master/lib/template_pool/template_pool.h>
#include <mail/template_master/lib/types/expected.h>

#include <mail/ymod_webserver/include/ymod_webserver/server.h>

namespace NTemplateMaster {

template<
        typename TContentProcessor,
        typename TContent,
        typename TDetempleObjectPtr>
class ITemplateMaster : public yplatform::module {
public:
    virtual TExpected<TDatabaseTemplates> FindSimilarTemplates(
            NTemplateMaster::TContextPtr,
            TDetempleObjectPtr,
            TYield) = 0;

    virtual void MergeTemplates(
            NTemplateMaster::TContextPtr,
            TStableTemplates<TContentProcessor, TContent>) = 0;

    virtual NTemplatePool::TTemplatePoolPtr<TContentProcessor, TContent, TDetempleObjectPtr>
            FindTemplatePool() = 0;

    virtual int GetMaxHashesCount() const = 0;

    virtual TContentProcessorPtr<TContentProcessor> GetContentProcessor() const = 0;

    virtual ~ITemplateMaster() = default;
};

template<typename TContentProcessor, typename TContent, typename TDetempleObjectPtr>
using TTemplateMasterPtr = std::shared_ptr<ITemplateMaster<TContentProcessor, TContent, TDetempleObjectPtr>>;
}
