#pragma once
#include <boost/functional/hash.hpp>

namespace NTemplateMaster::NTemplatePool {

class THashRange {
public:
    template<typename TIterator>
    auto operator()(TIterator begin, TIterator end) const {
        return boost::hash_range(begin, end);
    }
};

template<typename THasher, typename TIterator>
using THasherReturnType = std::result_of_t<THasher(TIterator, TIterator)>;

}
