#pragma once
#include <mail/yreflection/include/yamail/data/reflection.h>

namespace NTemplateMaster::NTemplatePool {

struct TConfig {
    size_t MaxCacheSize;
    std::string Reactor;
    double JacquardMinValueForDetemple;
    size_t MatchesForReadyTemplate;
    double CommonPartPercentForMatch;
    double CommonPartSmoothingCoefficient;
    size_t MaxHashesCount;
    size_t MaxTemplatesAfterFilter;
    size_t BucketsCount;
    size_t ElementsInBucket;
    size_t SimilarTemplatesLimit;
};
}

YREFLECTION_ADAPT_ADT(NTemplateMaster::NTemplatePool::TConfig,
    YREFLECTION_WO_MEMBER_RENAMED(std::size_t, max_cache_size, MaxCacheSize)
    YREFLECTION_WO_MEMBER_RENAMED(std::string, reactor, Reactor)
    YREFLECTION_WO_MEMBER_RENAMED(double, jacquard_min_value_for_detemple, JacquardMinValueForDetemple)
    YREFLECTION_WO_MEMBER_RENAMED(uint32_t, matches_for_ready, MatchesForReadyTemplate)
    YREFLECTION_WO_MEMBER_RENAMED(double, common_part_percent_coeff, CommonPartPercentForMatch)
    YREFLECTION_WO_MEMBER_RENAMED(double, smoothing_coefficient, CommonPartSmoothingCoefficient)
    YREFLECTION_WO_MEMBER_RENAMED(size_t, max_hashes_count, MaxHashesCount)
    YREFLECTION_WO_MEMBER_RENAMED(size_t, max_templates_after_filter, MaxTemplatesAfterFilter)
    YREFLECTION_WO_MEMBER_RENAMED(size_t, buckets_count, BucketsCount)
    YREFLECTION_WO_MEMBER_RENAMED(size_t, elements_in_bucket, ElementsInBucket)
    YREFLECTION_WO_MEMBER_RENAMED(size_t, similar_templates_limit, SimilarTemplatesLimit)
)
