#pragma once
#include <mail/template_master/lib/db/database_module.h>
#include <mail/template_master/lib/types/template/unstable_template.h>
#include <mail/template_master/lib/types/token/token.h>
#include <mail/template_master/lib/types/log.h>

namespace NTemplateMaster::NTemplatePool {

template<typename TContentProcessor, typename TContent>
class TSaveReadyTemplateOperation {
public:
    TSaveReadyTemplateOperation(int32_t featuresLimit)
        : FeaturesLimit(featuresLimit)
    {}

    void Save(
            TContextPtr context,
            TUnstableTemplatePtr<TContentProcessor, TContent> bestMatchTemplate,
            NDatabase::TDatabasePtr db) const noexcept
    {
        if (!bestMatchTemplate->IsSaved()) {
            const auto databaseTemplate = bestMatchTemplate->CreateDatabaseTemplate();
            const auto stable_sign = databaseTemplate->GetStableSign();
            const auto callback =
            [bestMatchTemplate, context, stable_sign] (TExpected<void> result) mutable noexcept {
                std::string status;
                if (result) {
                    status = "success";
                } else {
                    bestMatchTemplate->SetSaved(false);
                    status = "error";
                }
                LOGDOG_(context->GetLogger(), notice,
                        NTemplateMaster::NLog::type="Save",
                        NTemplateMaster::NLog::status=status,
                        NTemplateMaster::NLog::stable_sign=stable_sign)
            };
            bestMatchTemplate->SetSaved(true);
            db->AsyncSaveTemplate(context, databaseTemplate, FeaturesLimit, {}, callback);
        }
    }
private:
    const int32_t FeaturesLimit;
};

template<typename TContentProcessor, typename TContent>
using TSaveReadyTemplateOperationPtr = std::shared_ptr<TSaveReadyTemplateOperation<TContentProcessor, TContent>>;

}
