#pragma once
#include <mail/template_master/lib/types/log.h>
#include <mail/yplatform/include/yplatform/task_context.h>
#include <mail/ymod_webserver/include/ymod_webserver/request.h>

namespace NTemplateMaster {

class TContext: public yplatform::task_context {
public:
    TContext(ymod_webserver::context_ptr ctx, std::string request_id)
        : yplatform::task_context(*ctx)
        , RequestId(std::move(request_id))
        , Logger(NTemplateMaster::NLog::GetLogger(NTemplateMaster::NLog::templateMasterLogKey,
            uniq_id(), RequestId))
        , DebugLogger(NTemplateMaster::NLog::GetLogger(NTemplateMaster::NLog::templateMasterDebugLogKey,
            uniq_id(), RequestId))
    {}

     TContext(ymod_webserver::context_ptr ctx, std::string request_id, const std::string& queueId)
        : yplatform::task_context(*ctx)
        , RequestId(std::move(request_id))
        , Logger(NTemplateMaster::NLog::GetLogger(NTemplateMaster::NLog::templateMasterLogKey,
            uniq_id(), RequestId, queueId))
        , DebugLogger(NTemplateMaster::NLog::GetLogger(NTemplateMaster::NLog::templateMasterDebugLogKey,
            uniq_id(), RequestId, queueId))
    {}

    TContext(const TContext& other) = delete;
    auto& operator=(const TContext& rhs) = delete;

    const auto& GetRequestId() const & {
        return RequestId;
    }

    const auto& GetLogger() const & {
        return Logger;
    }

    const auto& GetDebugLogger() const & {
        return DebugLogger;
    }
private:
    const std::string RequestId;
    ::NTemplateMaster::NLog::TLogger Logger;
    ::NTemplateMaster::NLog::TLogger DebugLogger;
};

using TContextPtr = boost::shared_ptr<TContext>;
}
