#pragma once
#include <mail/expected/include/yamail/expected.h>

template<typename T>
using TExpected = yamail::expected<T, boost::system::error_code>;

template <typename T>
inline auto MakeExpected(T&& v) {
    using TResult = TExpected<std::decay_t<T>>;
    return TResult{std::forward<T>(v)};
}
