#pragma once
#include <mail/template_master/lib/types/match/similarity.h>
#include <mail/template_master/lib/types/template/stable_sign.h>
#include <mail/template_master/lib/types/unique_object.h>
#include <mail/template_master/lib/types/task.h>

#include <mail/logdog/include/logdog/logger.h>
#include <mail/logdog/include/logdog/format/json.h>
#include <mail/logdog/include/logdog/backend/yplatform_log.h>
#include <mail/logdog/include/logdog/attributes/mail_attributes.h>
#include <mail/logdog/include/logdog/level.h>

#include <boost/hana/for_each.hpp>
#include <boost/hana/fwd/concept/sequence.hpp>

#include <library/cpp/json/json_writer.h>
#include <library/cpp/scheme/scheme.h>

#include <vector>

namespace NTemplateMaster::NLog {

static const std::string templateMasterLogKey("template_master");
static const std::string templateMasterDebugLogKey("template_master_debug");

LOGDOG_DEFINE_ATTRIBUTE(std::string, uniq_id)
LOGDOG_DEFINE_ATTRIBUTE(std::string, type)
LOGDOG_DEFINE_ATTRIBUTE(std::string, url)
LOGDOG_DEFINE_ATTRIBUTE(std::string, status)
LOGDOG_DEFINE_ATTRIBUTE(std::string, body)
LOGDOG_DEFINE_ATTRIBUTE(std::string, diff)
LOGDOG_DEFINE_ATTRIBUTE(std::string_view, pq_message)
LOGDOG_DEFINE_ATTRIBUTE(std::string_view, query)
LOGDOG_DEFINE_ATTRIBUTE(NTemplateMaster::TTemplateStableSign, stable_sign)
LOGDOG_DEFINE_ATTRIBUTE(size_t, hits)
LOGDOG_DEFINE_ATTRIBUTE(double, smoothing_coeff)
LOGDOG_DEFINE_ATTRIBUTE(double, threshold)
LOGDOG_DEFINE_ATTRIBUTE(double, common_part_percent)
LOGDOG_DEFINE_ATTRIBUTE(NTemplateMaster::TSimilarity, similarity)
LOGDOG_DEFINE_ATTRIBUTE(size_t, pool_id)
LOGDOG_DEFINE_ATTRIBUTE(std::vector<NTemplateMaster::TTemplateUniqueId>, templates_unique_ids)
LOGDOG_DEFINE_ATTRIBUTE(std::vector<NTemplateMaster::TTemplateStableSign>, stable_signs)
LOGDOG_DEFINE_ATTRIBUTE(NTemplateMaster::TTemplateFeaturesSet, digest)
LOGDOG_DEFINE_ATTRIBUTE(std::chrono::milliseconds, duration_ms)
LOGDOG_DEFINE_ATTRIBUTE(bool, full_match)
LOGDOG_DEFINE_ATTRIBUTE(std::string, detemple_result)
LOGDOG_DEFINE_ATTRIBUTE(NTemplateMaster::TTasksInfos, tasks)
LOGDOG_DEFINE_ATTRIBUTE(std::string, queue_id)

using logdog::attr::exception;
using logdog::attr::message;
using logdog::attr::request_id;
using logdog::attr::error_code;

inline auto GetLogger(const std::string& logKey) {
    using yplatform::log::source;
    return logdog::make_log(
            logdog::json::formatter,
            std::make_shared<source>(YGLOBAL_LOG_SERVICE, logKey)
    );
}

inline auto GetLogger(std::string logKey, const std::string& uniqId, const std::string& requestId,
                      const std::string& queueId = "none") {
    return logdog::bind(GetLogger(logKey), uniq_id = uniqId, request_id = requestId, queue_id = queueId);
}

using TLogger = decltype(GetLogger(std::declval<std::string>(), std::declval<const std::string&>(),
                                   std::declval<const std::string&>(), std::declval<const std::string&>()));
}
