#pragma once
#include <mail/template_master/lib/types/template/attributes.h>
#include <mail/template_master/lib/types/template/stable_sign.h>
#include <mail/template_master/lib/types/template/template_sign.h>

#include <mail/yreflection/include/yamail/data/reflection.h>

#include <string>

namespace NTemplateMaster {

struct TDbHint {
    TTemplateStableSign StableSign;
    std::vector<TTemplateFeature> Features;
    std::string Tokens;
    std::string Attributes;
};

using TDbHints = std::vector<TDbHint>;

class THttpRouteRequest {
public:
    std::string Html;
    std::string From;
    std::string Subject;
    std::string QueueId;
    TUids Uids;
};

inline bool operator==(const THttpRouteRequest& lhs, const THttpRouteRequest& rhs) {
    return lhs.Html == rhs.Html && lhs.From == rhs.From && lhs.Subject == rhs.Subject && lhs.QueueId == rhs.QueueId && lhs.Uids == rhs.Uids;
}

class THttpDetempleRequest : public THttpRouteRequest {
public:
    THttpDetempleRequest() = default;

    THttpDetempleRequest(
            THttpRouteRequest routeRequest,
            TDbHints dbHints)
        : THttpRouteRequest(std::move(routeRequest)),
          DbHints(std::move(dbHints))
    {}

    std::optional<TDbHints> DbHints;
};

}

BOOST_FUSION_ADAPT_STRUCT(NTemplateMaster::TDbHint,
    (NTemplateMaster::TTemplateStableSign, StableSign)
    (std::vector<NTemplateMaster::TTemplateFeature>, Features)
    (std::string, Tokens)
    (std::string, Attributes)
)

YREFLECTION_ADAPT_ADT(NTemplateMaster::THttpRouteRequest,
    YREFLECTION_MEMBER_RENAMED(std::string, html, Html)
    YREFLECTION_MEMBER_RENAMED(std::string, from, From)
    YREFLECTION_MEMBER_RENAMED(std::string, subject, Subject)
    YREFLECTION_MEMBER_RENAMED(std::string, queueId, QueueId)
    YREFLECTION_MEMBER_RENAMED(NTemplateMaster::TUids, uids, Uids)
)

YREFLECTION_ADAPT_ADT(NTemplateMaster::THttpDetempleRequest,
    YREFLECTION_MEMBER_RENAMED(std::string, html, Html)
    YREFLECTION_MEMBER_RENAMED(std::string, from, From)
    YREFLECTION_MEMBER_RENAMED(std::string, subject, Subject)
    YREFLECTION_MEMBER_RENAMED(std::string, queueId, QueueId)
    YREFLECTION_MEMBER_RENAMED(NTemplateMaster::TUids, uids, Uids)
    YREFLECTION_MEMBER_RENAMED(std::optional<NTemplateMaster::TDbHints>, dbHints, DbHints)
)
