#pragma once
#include <mail/template_master/lib/types/template/stable_sign.h>
#include <mail/template_master/lib/types/token/token.h>
#include <mail/template_master/lib/types/match/delta.h>
#include <mail/template_master/lib/types/optional.h>
#include <mail/ymod_webserver/include/ymod_webserver/codes.h>

#include <mail/yreflection/include/yamail/data/reflection.h>
#include <boost/hana/string.hpp>

#include <string>

namespace NTemplateMaster {

    enum class ECreateTemplateStatus {
        Success,
        Error
    };

    class TCreateTemplateResult {
    public:
        TCreateTemplateResult(ECreateTemplateStatus status)
                : Status(status)
        {}

        TCreateTemplateResult(
                ECreateTemplateStatus status,
                TTemplateStableSign stable_sign
        )
                : Status(status)
                , StableSign(stable_sign)
        {}

        auto GetStatus() const noexcept {
            return Status;
        };

        static constexpr auto GetOperationName() noexcept  {
            using namespace boost::hana::literals;
            return "find_template"_s;
        }

        operator auto() const {
            return Status == ECreateTemplateStatus::Error ?
                   ymod_webserver::codes::internal_server_error :
                   ymod_webserver::codes::ok;
        }

        ECreateTemplateStatus Status;
        TOptional<TTemplateStableSign> StableSign;
    };
}

YREFLECTION_ADAPT_ENUM(NTemplateMaster::ECreateTemplateStatus,
    Success,
    Error)
