#pragma once
#include <mail/template_master/lib/types/optional.h>

#include <mail/ymod_webserver/include/ymod_webserver/codes.h>
#include <mail/yreflection/include/yamail/data/reflection.h>

#include <boost/hana/string.hpp>

namespace NTemplateMaster {

enum class EDeleteStatus {
    Success,
    Error
};

class TDeleteResult {
public:
    TDeleteResult(EDeleteStatus status)
        : Status(status)
    {}

    TDeleteResult(EDeleteStatus status, size_t deletedTemplates)
        : Status(status)
        , DeletedTemplatesCount(deletedTemplates)
    {}

    auto GetStatus() const noexcept {
        return Status;
    };

    static constexpr auto GetOperationName() noexcept  {
        using namespace boost::hana::literals;
        return "delete_template"_s;
    }

    operator auto() const noexcept {
        return Status == EDeleteStatus::Error ?
               ymod_webserver::codes::internal_server_error :
               ymod_webserver::codes::ok;
    }

    const EDeleteStatus Status;
    const TOptional<size_t> DeletedTemplatesCount;
};
}

YREFLECTION_ADAPT_ENUM(NTemplateMaster::EDeleteStatus,
    Success,
    Error)


