#pragma once
#include <mail/template_master/lib/types/template/stable_sign.h>
#include <mail/template_master/lib/types/match/delta.h>
#include <mail/template_master/lib/types/optional.h>
#include <mail/template_master/lib/types/template/attributes.h>

#include <mail/yreflection/include/yamail/data/reflection.h>
#include <mail/ymod_webserver/include/ymod_webserver/codes.h>

#include <boost/hana/string.hpp>

namespace NTemplateMaster {

enum class EDetempleStatus {
    FoundInDb,
    FoundInDbHints,
    FoundPreparedInPool,
    FoundNotReadyInPool,
    NotFound,
    Error
};

template<typename TTokenType, typename TAttributes>
class TDetempleResult {
public:
    TDetempleResult(EDetempleStatus status = EDetempleStatus::NotFound)
        : Status(status)
    {}

    TDetempleResult(EDetempleStatus status, TDelta<TTokenType> delta, std::vector<TAttributes> attributes)
        : Status(status)
        , Delta(std::move(delta))
        , Attributes(attributes)
    {}

    TDetempleResult(TDelta<TTokenType> delta, TTemplateStableSign stable_sign)
        : Status(EDetempleStatus::FoundInDb)
        , Delta(std::move(delta))
        , StableSign(stable_sign)
    {}

    TDetempleResult(
        EDetempleStatus status,
        TDelta<TTokenType> delta,
        TAttributesArray<TAttributes> attributes,
        TTemplateStableSign stable_sign
    )
        : Status(status)
        , Delta(std::move(delta))
        , Attributes(attributes)
        , StableSign(stable_sign)
    {}

    auto GetStatus() const noexcept {
        return Status;
    };

    static constexpr auto GetOperationName() noexcept  {
        using namespace boost::hana::literals;
        return "force_detemple"_s;
    }

    operator auto() const noexcept {
        return Status == EDetempleStatus::Error ?
               ymod_webserver::codes::internal_server_error :
               ymod_webserver::codes::ok;
    }

    EDetempleStatus Status;
    TOptional<TDelta<TTokenType>> Delta;
    TOptional<TAttributesArray<TAttributes>> Attributes;
    TOptional<TTemplateStableSign> StableSign;
};
}

YREFLECTION_ADAPT_ENUM(NTemplateMaster::EDetempleStatus,
    FoundInDb,
    FoundInDbHints,
    FoundPreparedInPool,
    FoundNotReadyInPool,
    NotFound,
    Error)

