#pragma once
#include <mail/template_master/lib/types/template/stable_sign.h>
#include <mail/template_master/lib/types/token/token.h>
#include <mail/template_master/lib/types/match/delta.h>
#include <mail/template_master/lib/types/optional.h>
#include <mail/ymod_webserver/include/ymod_webserver/codes.h>

#include <mail/yreflection/include/yamail/data/reflection.h>
#include <boost/hana/string.hpp>

#include <string>

namespace NTemplateMaster {

enum class EFindTemplateStatus {
    Found,
    NotFound,
    Error
};

template<typename TTokenType>
class TFindTemplateResult {
public:
    TFindTemplateResult(EFindTemplateStatus status)
        : Status(status)
    {}

    TFindTemplateResult(
        EFindTemplateStatus status,
        TTemplateStableSign stable_sign,
        const TTokenSequence<TTokenType>& tokens
    )
        : Status(status)
        , Chunks(std::in_place)
        , StableSign(stable_sign)
    {
        std::vector<std::string> curr_tokens;
        for (auto&& token : tokens) {
            if (token.IsSentinel() && !curr_tokens.empty()) {
                Chunks->emplace_back(std::move(curr_tokens));
            } else if (!token.IsSentinel()) {
                curr_tokens.emplace_back(token.GetValue());
            }
        }
    }

    auto GetStatus() const noexcept {
        return Status;
    };

    static constexpr auto GetOperationName() noexcept  {
        using namespace boost::hana::literals;
        return "find_template"_s;
    }

    operator auto() const {
        return Status == EFindTemplateStatus::Error ?
               ymod_webserver::codes::internal_server_error :
               ymod_webserver::codes::ok;
    }

    EFindTemplateStatus Status;
    TOptional<TTemplateChunks<TTokenType>> Chunks;
    TOptional<TTemplateStableSign> StableSign;
};
}

YREFLECTION_ADAPT_ENUM(NTemplateMaster::EFindTemplateStatus,
    Found,
    NotFound,
    Error)
