#pragma once
#include <mail/template_master/lib/types/time.h>

#include <mail/yreflection/include/yamail/data/reflection.h>

#include <boost/fusion/include/adapt_struct.hpp>

namespace NTemplateMaster {

using TUuid = std::string;

enum class ETaskStatus {
    NEW,
    STARTED,
    FAILED,
    SUCCESS,
    TIMEOUT
};

class TTaskInfo {
public:
    TTaskInfo(
            TUuid id,
            std::string taskType,
            TTimestamp scheduleTimestamp,
            TTimestamp createdTimestamp,
            TDuration timeout,
            ETaskStatus status,
            std::string context)
        : Id(id)
        , TaskType(std::move(taskType))
        , ScheduleTimestamp(std::chrono::system_clock::to_time_t(scheduleTimestamp))
        , CreatedTimestamp(std::chrono::system_clock::to_time_t(createdTimestamp))
        , Timeout(timeout)
        , Status(status)
        , Context(context)
    {}

    const TUuid Id;
    const std::string TaskType;
    const std::time_t ScheduleTimestamp;
    const std::time_t CreatedTimestamp;
    const TDuration Timeout;
    const ETaskStatus Status;
    const std::string Context;
};

using TTasksInfos = std::vector<TTaskInfo>;

class TTaskExecutionResult {
public:
    TTaskExecutionResult(ETaskStatus status, TOptional<std::string> error)
        : Status(status)
        , Error(error)
    {}

    ETaskStatus Status;
    TOptional<std::string> Error;
};

}

YREFLECTION_ADAPT_ENUM(NTemplateMaster::ETaskStatus,
    NEW,
    STARTED,
    FAILED,
    SUCCESS,
    TIMEOUT)

BOOST_FUSION_ADAPT_STRUCT(NTemplateMaster::TTaskInfo,
    Id,
    TaskType,
    ScheduleTimestamp,
    CreatedTimestamp,
    Status,
    Context
)
