#pragma once
#include <mail/template_master/lib/template_master/content_processor/traits.h>
#include <mail/template_master/lib/types/token/template_tokens.h>

namespace NTemplateMaster {

template<typename TContentProcessor, typename ContentType>
class TUnstableTemplate;

template<typename TContentProcessor, typename TContent>
class TMessage : public TTemplateTokens<TContentProcessor, TContent> {
public:
    static_assert(ContentProcessorConcept<TContentProcessor, TContent>, "must satisfy ContentProcessorConcept");

    using TAttributes = ContentProcessorAttributesType<TContentProcessor, TContent>;
    using typename TTemplateTokens<TContentProcessor, TContent>::TTokensSequenceType;
    using TTemplateTokens<TContentProcessor, TContent>::GetTokens;
    using TTemplateTokens<TContentProcessor, TContent>::GetFeatures;
    using TTemplateTokens<TContentProcessor, TContent>::GetContentProcessor;

    TMessage(TContentProcessor tokenizer, const TContent& content)
        : TTemplateTokens<TContentProcessor, TContent>(tokenizer, tokenizer.Tokenize(content))
        , Content(content)
        , Attributes(tokenizer.ExtractAttributes(content))
    {}

    const auto& GetContent() const & noexcept {
        return Content;
    }

    auto CreateUnstableTemplate() const noexcept {
        TTokensSequenceType templateTokens;
        templateTokens.emplace_back();
        templateTokens.insert(templateTokens.end(), GetTokens().begin(), GetTokens().end());
        templateTokens.emplace_back();
        return std::make_shared<TUnstableTemplate<TContentProcessor, TContent>>(GetContentProcessor(), templateTokens, Attributes);
    }

    const auto& GetAttributes() const & noexcept {
        return Attributes;
    }
private:
    const TContent Content;
    const TAttributes Attributes;
};

template<typename TContentProcessor, typename TContent>
using TMessagePtr = std::shared_ptr<TMessage<TContentProcessor, TContent>>;
}
