#pragma once
#include <mail/template_master/lib/types/token/template_tokens.h>
#include <mail/template_master/lib/types/template/stable_sign.h>

#include <string>

namespace NTemplateMaster {

template<typename TContentProcessor, typename TContent>
class TStableTemplate : public TTemplateTokens<TContentProcessor, TContent> {
public:
    static_assert(ContentProcessorConcept<TContentProcessor, TContent>, "must satisfy ContentProcessorConcept");
    using typename TTemplateTokens<TContentProcessor, TContent>::TTokensSequenceType;
    using TTemplateTokens<TContentProcessor, TContent>::GetTokens;
    using TTemplateTokens<TContentProcessor, TContent>::GetFeatures;
    using TTemplateTokens<TContentProcessor, TContent>::GetStableSign;

    TStableTemplate(TContentProcessor processor, std::string json, bool isEternal)
        : TTemplateTokens<TContentProcessor, TContent>(processor, processor.FromJson(json))
        , Eternal(isEternal)
    {}

    void UpdateTokens(TTokensSequenceType) {
        throw std::runtime_error("Can't update tokens in stable template");
    }

    bool IsEternal() const {
        return Eternal;
    }

private:
    bool Eternal; // Templates created by create_template should never be removed from DB
};

template<typename TContentProcessor, typename TContent>
using TStableTemplatePtr = std::shared_ptr<TStableTemplate<TContentProcessor, TContent>>;

template<typename TContentProcessor, typename TContent>
using TStableTemplates = std::vector<TStableTemplatePtr<TContentProcessor, TContent>>;
}
