#pragma once
#include <mail/template_master/lib/types/token/template_tokens.h>
#include <mail/template_master/lib/types/template/stable_sign.h>
#include <mail/template_master/lib/types/template/database_template.h>
#include <mail/template_master/lib/types/template/attributes.h>

#include <mail/yreflection/include/yamail/data/serialization/yajl.h>

#include <algorithm>

namespace NTemplateMaster {

template<typename TContentProcessor, typename TContent>
class TUnstableTemplate : public TTemplateTokens<TContentProcessor, TContent> {
public:
    static_assert(ContentProcessorConcept<TContentProcessor, TContent>, "must satisfy ContentProcessorConcept");

    using TAttributes = ContentProcessorAttributesType<TContentProcessor, TContent>;
    using typename TTemplateTokens<TContentProcessor, TContent>::TTokensSequenceType;
    using TTemplateTokens<TContentProcessor, TContent>::GetTokens;
    using TTemplateTokens<TContentProcessor, TContent>::GetFeatures;
    using TTemplateTokens<TContentProcessor, TContent>::GetStableSign;
    using TTemplateTokens<TContentProcessor, TContent>::Json;

    TUnstableTemplate(TContentProcessor tokenizer, TTokensSequenceType tokens, TAttributes attributes)
        : TTemplateTokens<TContentProcessor, TContent>(std::move(tokenizer), std::move(tokens))
        , HitCount(0)
        , Saved(false)
        , AttributesArray{attributes}
    {}

    auto CreateDatabaseTemplate() noexcept {
        return std::make_shared<TDatabaseTemplate>(GetStableSign(), GetFeatures(), Json(),
            yamail::data::serialization::toJson(AttributesArray).str());
    }

    void PushAttributes(TAttributes attributes) noexcept {
        AttributesArray.emplace_back(std::move(attributes));
    }

    const auto& GetAttributesArray() const & noexcept {
        return AttributesArray;
    }

    auto IsSaved() const noexcept {
        return Saved.load(std::memory_order_acquire);
    }

    void SetSaved(bool value) noexcept {
        Saved.store(value, std::memory_order_release);
    }

    void IncrementHits() noexcept {
        HitCount++;
    }

    auto GetHits() const noexcept {
        return HitCount;
    }
private:
    size_t HitCount;
    std::atomic_bool Saved;
    TAttributesArray<TAttributes> AttributesArray;
};

template<typename TContentProcessor, typename TContent>
using TUnstableTemplatePtr = std::shared_ptr<TUnstableTemplate<TContentProcessor, TContent>>;

template<typename TContentProcessor, typename TContent>
using TUnstableTemplates = std::vector<TUnstableTemplatePtr<TContentProcessor, TContent>>;
}
