#pragma once
#include <mail/template_master/lib/types/token/token.h>
#include <mail/template_master/lib/types/unique_object.h>
#include <mail/template_master/lib/types/template/stable_sign.h>
#include <mail/template_master/lib/types/template/template_sign.h>
#include <mail/template_master/lib/template_master/content_processor/traits.h>

#include <library/cpp/json/writer/json.h>

namespace NTemplateMaster {

template<typename TContentProcessor, typename TContentType>
class TTemplateTokens : public TUniqueObject {
public:
    static_assert(ContentProcessorConcept<TContentProcessor, TContentType>, "must satisfy ContentProcessorConcept");
    using TTokensSequenceType = ContentProcessorTokenSequenceType<TContentProcessor, TContentType>;

    TTemplateTokens(TContentProcessor tokenizer, TTokensSequenceType tokens)
        : ContentProcessor(std::move(tokenizer))
        , Tokens(std::move(tokens))
        , Digest(ContentProcessor.CalculateDigest(Tokens))
    {}

    decltype(auto) Json() const {
        return ContentProcessor.ToJson(Tokens);
    }

    auto Size() const noexcept {
        return Tokens.size();
    }

    const auto& GetTokens() const & noexcept {
        return Tokens;
    }

    const auto& GetFeatures() const & noexcept {
        return Digest;
    }

    auto GetStableSign() const noexcept {
        return ContentProcessor.CalculateStableSign(GetTokensWithoutSentinels());
    }

    void UpdateTokens(TTokensSequenceType tokens) noexcept {
        Tokens = std::move(tokens);
        Digest = ContentProcessor.CalculateDigest(Tokens);
    }

    const auto& GetContentProcessor() const & noexcept {
        return ContentProcessor;
    }
private:
    auto GetTokensWithoutSentinels() const noexcept {
        TTokensSequenceType result;
        for (auto&& token : GetTokens()) {
            if (!token.IsSentinel()) {
                result.emplace_back(token);
            }
        }
        return result;
    }
private:
    TContentProcessor ContentProcessor;
    TTokensSequenceType Tokens;
    TTemplateFeaturesSet Digest;
};

}
